# eLearn PHP + AJAX - Full Project (Demo)

This repository contains a minimal but complete e-learning platform scaffold built with:
- PHP (7.4+)
- MySQL / MariaDB (SQL schema included)
- jQuery AJAX for dynamic interactions
- Bootstrap 5 for basic responsive UI
- TCPDF for certificate PDF generation (composer dependency)

**Features included in this package**
- Course listing, course detail, enrollment (AJAX)
- Quiz engine (fetch + submit via AJAX), grading, attempts tracking
- Certificate generation (TCPDF) and verification
- Progress tracking and admin reports (CSV export)
- Payment integration pattern + webhook handler (example for Stripe-style)
- Admin pages for course and quiz management (skeletons)

## Quick setup (local)
1. Place the `public/` folder under your web server root (e.g. Apache `htdocs`).
2. Create a MySQL database and import `sql/schema.sql`.
3. Update `includes/config.php` with DB credentials and `base_url`.
4. Install composer dependencies (for TCPDF) if you plan to use certificates:
   ```
   composer require tecnickcom/tcpdf
   ```
5. Ensure `storage/` is writable by the web user for certificates.
6. Visit `public/index.php`.

This package is a starting point and intentionally minimal. Review security notes in `includes/README_SECURITY.md`.

