<?php
require_once __DIR__ . '/../../includes/auth.php';
$u = current_user(); if (!$u || $u['role'] !== 'admin') { header('Location: ../index.php'); exit; }
$id = $_GET['id'] ?? null;
$course = null;
if ($id) {
  $stmt = db()->prepare('SELECT * FROM courses WHERE id = ?'); $stmt->execute([$id]); $course = $stmt->fetch();
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $title = $_POST['title']; $desc = $_POST['description']; $price = $_POST['price'];
  $slug = preg_replace('/[^a-z0-9]+/','-',strtolower($title));
  if ($id) {
    $upd = db()->prepare('UPDATE courses SET title=?,description=?,price=?,slug=? WHERE id=?'); $upd->execute([$title,$desc,$price,$slug,$id]);
  } else {
    $ins = db()->prepare('INSERT INTO courses (title,slug,description,price) VALUES(?,?,?,?)'); $ins->execute([$title,$slug,$desc,$price]);
  }
  header('Location: course_list.php'); exit;
}
include __DIR__ . '/../../includes/header.php';
?>
<div class="container">
  <h2><?= $course ? 'Edit Kursus' : 'Buat Kursus' ?></h2>
  <form method="post">
    <div class="mb-3"><label>Judul</label><input name="title" class="form-control" value="<?=htmlspecialchars($course['title'] ?? '')?>"></div>
    <div class="mb-3"><label>Deskripsi</label><textarea name="description" class="form-control"><?=htmlspecialchars($course['description'] ?? '')?></textarea></div>
    <div class="mb-3"><label>Harga</label><input name="price" type="number" step="0.01" class="form-control" value="<?=htmlspecialchars($course['price'] ?? 0)?>"></div>
    <button class="btn btn-primary">Simpan</button>
  </form>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>