<?php
require_once __DIR__ . '/../../includes/auth.php';
$u = current_user(); if (!$u || $u['role'] !== 'admin') { header('Location: ../index.php'); exit; }
$courses = db()->query('SELECT * FROM courses ORDER BY created_at DESC')->fetchAll();
include __DIR__ . '/../../includes/header.php';
?>
<div class="container">
  <h2>Kelola Kursus</h2>
  <a href="course_edit.php" class="btn btn-primary mb-3">Buat Kursus Baru</a>
  <table class="table">
    <thead><tr><th>#</th><th>Judul</th><th>Slug</th><th>Aksi</th></tr></thead>
    <tbody>
      <?php foreach ($courses as $c): ?>
      <tr>
        <td><?=htmlspecialchars($c['id'])?></td>
        <td><?=htmlspecialchars($c['title'])?></td>
        <td><?=htmlspecialchars($c['slug'])?></td>
        <td><a href="course_edit.php?id=<?=urlencode($c['id'])?>" class="btn btn-sm btn-outline-secondary">Edit</a></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>