<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/config.php';

$user = current_user(); if (!$user) { header('Location: ../index.php?page=login'); exit; }
$course_id = (int)($_GET['course_id'] ?? 0);

// Check progress threshold
$stmt = db()->prepare('SELECT progress FROM enrollments WHERE user_id=? AND course_id=?');
$stmt->execute([$user['id'],$course_id]); $en = $stmt->fetch();
if (!$en || $en['progress'] < 90) { echo 'Belum menyelesaikan kursus (progress < 90%)'; exit; }

// Generate certificate using TCPDF (requires composer: tecnickcom/tcpdf)
require_once __DIR__ . '/../../vendor/autoload.php';
use \TCPDF;

$code = strtoupper(uniqid('CERT'));
$pdf = new TCPDF('L','mm','A4', true, 'UTF-8', false);
$pdf->SetCreator('eLearnID');
$pdf->SetTitle('Sertifikat Penyelesaian');
$pdf->SetMargins(15,15,15);
$pdf->AddPage();
$pdf->SetFont('helvetica','B',24);
$pdf->Cell(0,10,'SERTIFIKAT PENYELESAIAN',0,1,'C');
$pdf->Ln(6);
$pdf->SetFont('helvetica','',16);
$pdf->Cell(0,10,"Diberikan kepada: {$user['name']}",0,1,'C');
$pdf->Ln(4);
$course = db()->prepare('SELECT title FROM courses WHERE id = ?'); $course->execute([$course_id]); $c = $course->fetchColumn();
$pdf->Cell(0,8,"Telah menyelesaikan kursus: {$c}",0,1,'C');
$pdf->Ln(14);
$pdf->SetFont('helvetica','',12);
$pdf->Cell(0,8,"Kode Sertifikat: {$code}",0,1,'C');

// Save file
$config = require __DIR__ . '/../../includes/config.php';
$certDir = $config['storage_path'] . '/certificates'; if (!is_dir($certDir)) mkdir($certDir, 0755, true);
$filename = $certDir . "/certificate_{$user['id']}_{$course_id}_" . time() . '.pdf';
$pdf->Output($filename, 'F');

// store record
$ins = db()->prepare('INSERT INTO certificates (user_id,course_id,issued_at,certificate_code,pdf_path) VALUES(?,?,?,?,?)');
$ins->execute([$user['id'],$course_id,date('Y-m-d H:i:s'),$code, $filename]);

header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="certificate.pdf"');
readfile($filename);
?>