<?php
// Webhook endpoint example (Stripe-style). Adjust to provider SDK and signature verification.
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/helpers.php';

// For demo: read raw body and parse JSON
$payload = @file_get_contents('php://input');
$event = json_decode($payload, true);
if (!$event) {
  http_response_code(400); exit;
}

// Example: event type 'checkout.session.completed'
$type = $event['type'] ?? '';
if ($type === 'checkout.session.completed') {
  // extract metadata that contains internal payment id
  $session = $event['data']['object'] ?? [];
  $provider_payment_id = $session['id'] ?? null;
  $metadata = $session['metadata'] ?? [];
  $paymentId = $metadata['payment_id'] ?? null;

  if ($paymentId) {
    $stmt = db()->prepare('UPDATE payments SET status = ?, provider = ?, provider_payment_id = ? WHERE id = ?');
    $stmt->execute(['paid', 'stripe', $provider_payment_id, $paymentId]);
    // enroll user if metadata contained user_id and course_id
    if (!empty($metadata['user_id']) && !empty($metadata['course_id'])) {
      $u = (int)$metadata['user_id']; $c = (int)$metadata['course_id'];
      try {
        $ins = db()->prepare('INSERT IGNORE INTO enrollments (user_id,course_id,progress) VALUES(?,?,0)');
        $ins->execute([$u,$c]);
      } catch (Exception $e) { /* log */ }
    }
  }
}

http_response_code(200);
echo json_encode(['ok'=>true]);
?>