<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/helpers.php';
header('Content-Type: application/json');

$user = current_user(); if (!$user) json_response(['ok'=>false,'msg'=>'login required']);
$action = $_POST['action'] ?? '';
if ($action === 'complete_lesson') {
  $lesson_id = (int)($_POST['lesson_id'] ?? 0);
  // insert into user_lessons
  try {
    $ins = db()->prepare('INSERT INTO user_lessons (user_id,lesson_id,completed_at) VALUES(?,?,NOW())');
    $ins->execute([$user['id'],$lesson_id]);
  } catch (Exception $e) { /* ignore duplicate */ }
  // recompute progress
  $courseRow = db()->prepare('SELECT course_id FROM lessons WHERE id = ?'); $courseRow->execute([$lesson_id]); $course_id = $courseRow->fetchColumn();
  $completed = db()->prepare('SELECT COUNT(*) FROM user_lessons ul JOIN lessons l ON l.id=ul.lesson_id WHERE ul.user_id=? AND l.course_id=?');
  $completed->execute([$user['id'],$course_id]); $c = $completed->fetchColumn();
  $total = db()->prepare('SELECT COUNT(*) FROM lessons WHERE course_id = ?'); $total->execute([$course_id]); $t = $total->fetchColumn();
  $progress = $t>0 ? round(($c / $t) * 100,2) : 0;
  $upd = db()->prepare('UPDATE enrollments SET progress = ? WHERE user_id=? AND course_id=?');
  $upd->execute([$progress, $user['id'], $course_id]);
  json_response(['ok'=>true,'progress'=>$progress]);
}
json_response(['ok'=>false,'msg'=>'unknown action']);
?>