<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/helpers.php';
header('Content-Type: application/json');
$action = $_REQUEST['action'] ?? '';
if ($action === 'fetch') {
  $quiz_id = (int)($_GET['quiz_id'] ?? 0);
  $stmt = db()->prepare('SELECT q.*, l.title AS lesson_title FROM quizzes q JOIN lessons l ON l.id=q.lesson_id WHERE q.id = ?');
  $stmt->execute([$quiz_id]); $quiz = $stmt->fetch();
  if (!$quiz) json_response(['ok'=>false,'msg'=>'Quiz not found']);
  $questions = db()->prepare('SELECT * FROM questions WHERE quiz_id = ? ORDER BY `order` ASC');
  $questions->execute([$quiz_id]); $qs = $questions->fetchAll();
  foreach ($qs as &$q) {
    if ($q['question_type'] !== 'short_text') {
      $ch = db()->prepare('SELECT id,text FROM choices WHERE question_id = ? ORDER BY `order` ASC');
      $ch->execute([$q['id']]); $q['choices'] = $ch->fetchAll();
    }
  }
  json_response(['ok'=>true,'quiz'=>$quiz,'questions'=>$qs]);
}
if ($action === 'submit' && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $user = current_user(); if (!$user) json_response(['ok'=>false,'msg'=>'login required']);
  $quiz_id = (int)($_POST['quiz_id'] ?? 0);
  $answers_raw = $_POST['answers'] ?? null;
  // answers expected as JSON string or array
  if (is_string($answers_raw)) { $answers = json_decode($answers_raw, true); } else { $answers = $answers_raw ?? []; }

  $qStmt = db()->prepare('SELECT * FROM questions WHERE quiz_id = ?'); $qStmt->execute([$quiz_id]); $questions = $qStmt->fetchAll();
  $total_points = 0; $earned = 0; $details = [];
  foreach ($questions as $q) {
    $total_points += $q['points'];
    $qid = $q['id'];
    $userAnswer = $answers[$qid] ?? null;
    $row = ['question_id' => $qid, 'type'=>$q['question_type'], 'points'=>$q['points'], 'correct'=>false, 'earned'=>0];
    if ($q['question_type'] === 'short_text') {
      if (!empty($userAnswer)) { $earned += $q['points']; $row['correct']=true; $row['earned']=$q['points']; }
    } else if ($q['question_type'] === 'mcq_single') {
      $cStmt = db()->prepare('SELECT id FROM choices WHERE question_id = ? AND is_correct = 1');
      $cStmt->execute([$qid]); $correctChoice = $cStmt->fetchColumn();
      if ($correctChoice && (int)$userAnswer === (int)$correctChoice) { $earned += $q['points']; $row['correct']=true; $row['earned']=$q['points']; }
    } else if ($q['question_type'] === 'mcq_multiple') {
      $cStmt = db()->prepare('SELECT id FROM choices WHERE question_id = ? AND is_correct = 1');
      $cStmt->execute([$qid]); $correct = $cStmt->fetchAll(PDO::FETCH_COLUMN);
      $userSel = is_array($userAnswer) ? array_map('intval', $userAnswer) : [];
      $intersection = array_intersect($correct, $userSel);
      if (count($correct) > 0) {
        $scoreFrac = count($intersection) / count($correct);
        $earnedPart = $q['points'] * $scoreFrac;
        $earned += $earnedPart; $row['earned']=$earnedPart; if ($earnedPart>0) $row['correct']=true;
      }
    }
    $details[] = $row;
  }
  $percentage = $total_points > 0 ? ($earned / $total_points) * 100 : 0;
  $quizMeta = db()->prepare('SELECT passing_score FROM quizzes WHERE id = ?'); $quizMeta->execute([$quiz_id]); $qm = $quizMeta->fetch();
  $passing = $qm['passing_score'] ?? 70; $passed = $percentage >= $passing;
  $ins = db()->prepare('INSERT INTO quiz_attempts (user_id,quiz_id,score,max_score,passed,finished_at,details) VALUES(?,?,?,?,?,NOW(),?)');
  $ins->execute([$user['id'],$quiz_id,$earned,$total_points,$passed,json_encode($details)]);
  json_response(['ok'=>true,'score'=>$earned,'max'=>$total_points,'percentage'=>$percentage,'passed'=>$passed,'details'=>$details]);
}
json_response(['ok'=>false,'msg'=>'unknown action']);
?>