<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';
require_once __DIR__ . '/../includes/auth.php';

$page = $_GET['page'] ?? 'home';
function view($name, $data = []) {
  extract($data);
  include __DIR__ . "/../includes/header.php";
  include __DIR__ . "/../views/{$name}.php";
  include __DIR__ . "/../includes/footer.php";
}

if ($page === 'home') {
  $courses = db()->query('SELECT * FROM courses ORDER BY created_at DESC LIMIT 12')->fetchAll();
  view('home', ['courses' => $courses]);
  exit;
}

if ($page === 'courses') {
  $courses = db()->query('SELECT * FROM courses ORDER BY created_at DESC')->fetchAll();
  view('courses', ['courses' => $courses]);
  exit;
}

if ($page === 'course') {
  $slug = $_GET['slug'] ?? '';
  $stmt = db()->prepare('SELECT * FROM courses WHERE slug = ?');
  $stmt->execute([$slug]);
  $course = $stmt->fetch();
  if (!$course) { echo 'Course not found'; exit; }
  $lessons = db()->prepare('SELECT * FROM lessons WHERE course_id = ? ORDER BY `order` ASC');
  $lessons->execute([$course['id']]);
  $lessons = $lessons->fetchAll();
  view('course', ['course' => $course, 'lessons' => $lessons]);
  exit;
}

if ($page === 'login') {
  $error = null;
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $pass = $_POST['password'] ?? '';
    $stmt = db()->prepare('SELECT id,password,name,role FROM users WHERE email = ?');
    $stmt->execute([$email]);
    $u = $stmt->fetch();
    if ($u && password_verify($pass, $u['password'])) {
      $_SESSION['user_id'] = $u['id'];
      header('Location: index.php'); exit;
    } else { $error = 'Email atau password salah'; }
  }
  view('login', ['error' => $error]);
  exit;
}

if ($page === 'logout') {
  session_destroy(); header('Location: index.php'); exit;
}

if ($page === 'dashboard') {
  $u = current_user();
  if (!$u) { header('Location: index.php?page=login'); exit; }
  // simple dashboard
  $enroll = db()->prepare('SELECT e.*, c.title FROM enrollments e JOIN courses c ON c.id=e.course_id WHERE e.user_id=?');
  $enroll->execute([$u['id']]); $myCourses = $enroll->fetchAll();
  view('dashboard', ['user'=>$u, 'myCourses'=>$myCourses]);
  exit;
}

// admin skeleton (basic auth check)
if ($page === 'admin') {
  $u = current_user(); if (!$u || $u['role'] !== 'admin') { header('Location: index.php'); exit; }
  view('admin_index', []);
  exit;
}

// fallback
view('home', ['courses' => db()->query('SELECT * FROM courses LIMIT 6')->fetchAll()]);
?>