<div class="row">
  <div class="col-lg-8">
    <h2><?=htmlspecialchars($course['title'])?></h2>
    <p><?=nl2br(htmlspecialchars($course['description']))?></p>

    <h4>Materi</h4>
    <ul class="list-group mb-3">
      <?php foreach ($lessons as $l): ?>
        <li class="list-group-item d-flex justify-content-between align-items-center">
          <div>
            <strong><?=htmlspecialchars($l['title'])?></strong>
            <div class="text-muted small"><?=htmlspecialchars($l['content_type'])?> • <?=htmlspecialchars($l['duration'])?></div>
          </div>
          <div>
            <a href="#" class="btn btn-sm btn-outline-primary">Mulai</a>
          </div>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>
  <div class="col-lg-4">
    <div class="card p-3">
      <h5>Ringkasan</h5>
      <p>Harga: <?=htmlspecialchars($course['price'])?></p>
      <button onclick="enrollCourse(<?=json_encode($course['id'])?>, this)" class="btn btn-success">Daftar</button>
      <?php if (!empty($course['id'])): ?>
      <div class="mt-3">
        <a href="api/certificate.php?course_id=<?=urlencode($course['id'])?>" class="btn btn-outline-secondary">Cetak Sertifikat (jika sudah selesai)</a>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
